### Stock

- Improved that when editing a unit conversion, the "Quantity unit from" and "Quantity unit to" of the corresponding inverse conversion is now also updated accordingly if changed (until now only the factor was updated automatically)
- Changed that the "Move on open" product option can now always be used/set, even when the "Default location" and "Default consume location" are the same
- Fixed that stock entry notes were lost when consuming/opening/transferring a partial amount of the corresponding stock entry (thanks @akoshpinter)
- Fixed that the average shelf life of a product (on the product card) was wrong when the corresponding stock entry was edited
- Fixed that when the stock setting "Decimal places allowed for amounts" was set to `0`, unit conversion (if any) failed when adding the corresponding product to stock
- Fixed that consuming a parent product which is not in stock itself (so essentially using any of the child products) may failed when unit conversions were involved (the current stock amount check was wrong in that case)
- Fixed that the status button counters on the stock overview page ("X products are overdue" and so on) included products which have the option `Never show on stock overview` enabled
- Fixed that adding Userfields to existing stock entries was not possible (only editing existing Userfield values, e.g. added during purchase or inventory, was possible)
- Fixed that it was not possible to change a products stock QU, when the needed unit conversion (old QU => new QU) was only defined globally (means on QU level) or by the products "Factor purchase to stock quantity unit"
- Fixed that when changing a products stock QU, the products "Quick consume mount", "Energy (kcal)" and "Tare weight" wasn't updated according to the corresponding unit conversion factor
- Fixed that when changing a products stock QU, the product barcode amounts were also changed based on the corresponding unit conversion factor

### Shopping list

- Fixed that products could not be added to the shopping list via barcode scanning

### Recipes

- Fixed that headlines in the recipe description (preparation text) were removed on saving
- Fixed that the default consume rule was not always applied correctly when a recipe consumed a substituted ingredient (so when having a parent product in the recipe which is currently not in stock itself)

### Userfields

- Fixed that edit forms were broken when editing an object with `null` Userfields (so when the field for that object was not set before / on the initial object creation)

### General

- It's now possible to edit a user without necessarily updating the users password
- Fixed that column reordering didn't work on the stock overview, stock entries and shopping list page when showing columns which are not shown by default
- Fixed that when running label printer WebHooks client side (so when `LABEL_PRINTER_RUN_SERVER` = `false`), the setting `LABEL_PRINTER_HOOK_JSON` was ignored (the WebHook data was always sent as form data)
- Fixed that granular user permissions (like "Shopping list / Add items" or "Equipment") didn't allow to add/edit the corresponding items without also having the "Edit master data" permission
- New translations: (thanks all the translators)
  - Lithuanian (demo available at <https://lt.demo.grocy.info>)
  - Ukrainian (demo available at <https://uk.demo.grocy.info>)

### API

- Endpoint `/stock/volatile`
  - The field/property `missing_products` now also contains the `product` object
- Endpoint `/recipes/{recipeId}/consume`: Fixed (again) that consuming partially fulfilled recipes was possible, although an error was already returned in that case (and potentially some of the in stock ingredients were consumed in fact)
