### Stock

- The `config.php` option `FEATURE_SETTING_STOCK_COUNT_OPENED_PRODUCTS_AGAINST_MINIMUM_STOCK_AMOUNT` was removed and is now a new product option `Treat opened as out of stock`, means, if opened stock entries will be counted as missing for calculating if a product is below its minimum stock amount, can now be configured per product
  - The existing option will be migrated to all existing products, so no changed behavior after the update
  - There is also a new stock setting (section "Presets for new products") which can be used to configure the default when adding products (also that will be set based on the old setting on migration)
- When using/scanning a stock entry Grocycode on the consume page, the amount is now prefilled by the stock entry amount (making it essentially possible to consume the corresponding stock entry in one go)
- Stock entry labels get now also printed on inventory (only when adding products, same option "Stock entry label" like on the purchase page)
- Fixed that stock entry labels on purchase were printed, even when "No label" was selected (was only a problem when running label printer WebHooks server side)
- Fixed that formatted (HTML) text for the (hidden by default) product description column on the stock overview page was not correctly displayed
- Fixed that numeric and date-time sorting of table columns on the stock entries page did not work correctly (thanks @MasterofJOKers)
- Fixed that the consume page/dialog wasn't properly initialized when opening it from the stock entries page
- Fixed that entries for not existing users were missing on the stock journal

### Recipes

- Optimized recipe costs calculation to better reflect the current real costs: Out of stock ingredients now use the last price
  - Background: Before v3.0.0 recipe costs were only based on the last price per product and since v3.0.0 the "real costs" (based on the default consume rule "Opened first, then first due first, then first in first out") are used, means out of stock items have no price - so using the last price for out of stock items should reflect the current real costs better
- Added a new recipes setting (top right corner settings menu) "Show the recipe list and the recipe side by side" (defaults to enabled, so no changed behaviour when not configured)
  - When disabled, on the recipes page, the recipe list is displayed full-width and the recipe will be shown in a popup instead of on the right side
- Recipes are now also Grocycode enabled (works like any other Grocycode; download/print it via the recipes edit page or the more/context menu on the recipes page; use/scan it at any place a recipe can be selected)
- Performance improvements (page loading time) of the recipes page
- Fixed that when adding missing recipe ingredients, with the option "Only check if any amount is in stock" enabled, to the shopping list, unit conversions (if any) weren't considered
- Fixed that the recipe stock fulfillment information about shopping list amounts was not correct when the ingredient had a decimal amount

### Meal plan

- Meal plan sections can now (optionally) define a time, which will then be displayed on the meal plan section header and used for the corresponding calendar events
  - Additionally the correspnding calendar event now also mentions the meal plan section name
- The day/week view can now be toggled
  - New button on top right corner of the meal plan (only visible on bigger screens)
  - On smaller screen the day view is still the default (no change)
- Fixed that the meal plan showed the total calories per recipe (instead of per serving as stated by the suffix)

### Chores

- Chore schedules can now be skipped
  - New button on the chores overview and chore tracking page
  - Skipped schedules will be highlighted accordingly on the chore journal
- Added a new chore option "Start date" which is used as a schedule starting point when the chore was never tracked
  - Until now, the schedule starting point was the first tracked execution
  - For all existing chores, the start date will be set to the first tracked execution time (or today, for chores which were never tracked) on migration
- The `Yearly` period type has been changed to be schedule the chore on the _same day_ each year
  - This period type scheduled chores 1 year _after the last execution_ before, which is also possible by using the `Daily` period type and a period interval of 365 days; all existing `Yearly` schedules will be converted to that on migration
- Added a new `Hourly` period type (to schedule chores every `x` hours)
- Added a new `Adaptive` period type (to schedule chores dynamically based on the past average execution frequency)
- Removed the period type `Dynamic regular`, since it's the same as `Daily`
  - All existing `Dynamic regular` schedules will be converted to that on migration
- The chorecard now also shows the average execution frequency (how often the chore was executed in the past on average)

### Calendar

- Fixed that when having a task without a due date, the iCal export was broken

### Tasks

- Added a "Save & add another task"-button on the add task dialog to quickly create multiple tasks without having to close/reopen the dialog
- Fixed that when editing a task without a due date, `1970-01-01` was shown

### General

- Added a separate status filter and table row highlighting (blue) on the chores, tasks and batteries overview pages for items due today
  - Additionally, the "due soon" days of chores/tasks/batteries (top right corner settings menu) can be set to `0` to disable that filter/highlighting
- Optimized relative time display (also fixed a phrasing problem for some languages, e.g. Hungarian) (thanks @Tallyrald)
- New input shorthand `[+/-]n[d/m/y]` for date fields to quickly input a date relative to today (adding (**+**) or subtracting (**-**) the **n**umber of **d**ays/**m**onths/**y**ears, see the full list of available shorthands [here](https://github.com/grocy/grocy#input-shorthands-for-date-fields))
- When using LDAP authentication, the configured `LDAP_UID_ATTR` is now used to compare if the user already exists instead of the username entered on the login page (that prevents creating multiple users if you enter the username in different notations) (thanks @FloSet)
- When using reverse proxy authentication (`ReverseProxyAuthMiddleware`), it's now also possible to pass the username in an environment variable instead of an HTTP header (new `config.php` option `REVERSE_PROXY_AUTH_USE_ENV`) (thanks @Forceu)
- The `config.php` option `DISABLE_BROWSER_BARCODE_CAMERA_SCANNING` has been renamed to `FEATURE_FLAG_DISABLE_BROWSER_BARCODE_CAMERA_SCANNING`
- Fixed that when having a quantity unit matching any application string, the translation of that string was used to display that unit
- Fixed that the logout button/menu was missing when using external authentication (e.g. LDAP)
- New translations: (thanks all the translators)
  - Catalan (demo available at https://ca.demo.grocy.info)

### API

- The API endpoint `/stock/shoppinglist/clear` has now a new optional request body parameter `done_only` (to only remove done items from the given shopping list, defaults to `false`)
- The API endpoint `/chores/{choreId}/execute` has now a new optional request body parameter `skipped` (to skip the next chore schedule, defaults to `false`)
- The API endpoint `/chores/{choreId}` has new response field/property `average_execution_frequency_hours` (contains the average past execution frequency in hours or `null`, when the chore was never executed before)
- New API endpoint `/recipes/{recipeId}/printlabel` (to print recipe grocycodes on the configured label printer)
- Fixed that the barcode lookup for the "Stock by-barcode" API endpoints was case sensitive
