'use strict';

export default {
	center: function(arc, stretch) {
		var angle = (arc.startAngle + arc.endAngle) / 2;
		var cosA = Math.cos(angle);
		var sinA = Math.sin(angle);
		var d = arc.outerRadius;

		var stretchedD = d + stretch;
		return {
			x: arc.x + cosA * stretchedD,
			y: arc.y + sinA * stretchedD,
			d: stretchedD,
			arc: arc,
			anchor: {
				x: arc.x + cosA * d,
				y: arc.y + sinA * d,
			},
			copy: {
				x: arc.x + cosA * stretchedD,
				y: arc.y + sinA * stretchedD
			}
		};
	},

	moveFromAnchor: function(center, dist) {
		var arc = center.arc;
		var d = center.d;
		var angle = (arc.startAngle + arc.endAngle) / 2;
		var cosA = Math.cos(angle);
		var sinA = Math.sin(angle);

		d += dist;

		return {
			x: arc.x + cosA * d,
			y: arc.y + sinA * d,
			d: d,
			arc: arc,
			anchor: center.anchor,
			copy: {
				x: arc.x + cosA * d,
				y: arc.y + sinA * d
			}
		};
	}
};
