> ⚠️ PHP 8.1 (with SQLite 3.34.0+) is from now on the only supported runtime version.

> ❗ The major version bump is due to breaking API changes, please see below if you use the API.

> _Recommendation: Benchmark tests showed that e.g. unit conversion handling is up to 5 times faster when using a more recent (3.39.4+) SQLite version._

### New Feature: Indirect quantity unit conversions with unlimited levels

- Quantity unit conversions now support indirect conversions with unlimited levels (thanks a lot @esclear)
  - _Explained by a practical example: When a conversion between Teaspoons and Milliliters and another one between Milliliters and Liters exists (and so forth; unlimited levels), Grocy can now calculate Teaspoons to Liters (before a direct conversion definition between Teaspoons and Liters was required)_
  - **Heads up:** If you have such "each to each absolute conversion definitions" currently (for the example above the conversion between Teaspoons and Liters), you should clean them up, since they are no longer needed
- The product option "Factor purchase to stock quantity unit" was removed
  - => Use normal product specific QU conversions instead, if needed
  - An existing "Factor purchase to stock quantity unit" was automatically migrated to a product specific QU conversion

### New Feature: Stock reports

- New button "Reports" on the stock overview page
- The first report (more to come) "Spendings" makes it possible to explore (pie chart and table data) the total value spend by product or product group in any time range
- (Thanks for the initial work on this @raupie)

### Stock

- New product option "Default quantity unit consume"
  - Will be used/selected as the default quantity unit on the consume page
  - The product's "Quick consume amount" is now displayed related to this quantity unit ("quick consume/open buttons" on the stock overview page)
  - Defaults to the product's "Quantity unit stock" (so no changed behavior when not configured)
- New product option "Quantity unit for prices"
  - Prices are now shown related to this quantity unit (instead of per "Default quantity unit purchase") on the product card, price history chart, stock overiew and stock entries page
  - Defaults to the product's "Default quantity unit purchase" (so no changed behavior when not configured)
- Changed that when the ingredient option "Only check if any amount is in stock" is enabled, costs and calories are now based on the original entered amount instead of an "virtual" fixed amount of `1`
- When using the "Add as barcode to existing product" workflow on a purchase transaction, the selected quantity unit and the entered amount and note are now also added to the new barcode
- New product option "Auto reprint stock entry label"
  - When enabled, auto-changing the due date of a stock entry (by opening/freezing/thawing and having corresponding default due days set) will reprint its label (only server side label printer WebHooks are supported)
  - Defaults to disabled, so no changed behavior when not configured
- Added a new option "Reprint stock entry label" on the stock entry edit page (will print the correspondind stock entry label on save)
  - This option will be automatically set on changing the entry's due date
- The product option "Quick consume amount" (the amount used for the "quick consume/open buttons" on the stock overview page) has been split into another option "Quick open amount", to be able to set different amounts for consume and open (defaults to the "Quick consume amount" per product, so no changed behavior when not configured)
- Changed that for the product's average and last price (and for the price history chart) stock transactions with an empty or `0` price are ignored
- Added a filter option to only show currently out of stock products on the products list (master data) page
- When clicking a product name on the products list (master data) or on the stock journal page, the product card will now be displayed (like on the stock overview page)
- When using/scanning a product barcode and the purchase or inventory page, the barcode's note will now also be prefilled (if any)
- Each row on the stock journal now also has a context-/more menu for quick access to product related actions (the same as on the stock overview page)
- The amount of "Label per unit" stock entry labels (on purchase and inventory) is now displayed, to help prevent printing a lot of labels where this maybe is not intended
- Fixed that hiding the "Purchased date" column (table options) on the stock entries page didn't work
- Fixed that sorting by the "Value" and "Min. stock amount" columns on the stock overview page didn't work
- Fixed that the consumed amount was wrong, when consuming multiple substituted subproducts at once and when multiple/different conversion factors were involved
- Fixed that for a product's average price, only currently in stock items were considered, not already consumed ones
- Fixed that when copying a product, some fields (like "Default consume location" or "Disable own stock) weren't copied along
- Fixed that the total product count on the stock overview page also included products with "Never show on stock overview" enabled

### Shopping list

- Added a new button "Clear done items" (to clear all done items with one click)

### Recipes

- Added a new entry "Add to meal plan" in the context/more menu per recipe to directly add a recipe to the meal plan from the recipes page
- Changed that when a ingredient has a "Variable amount" set, the text entered there now also replaces the unit when displaying the recipe (not only the amount as before)
- When displaying a recipe in fullscreen mode, the ingredients and preparation is now shown side by side (or below each other on small screens) instead of in tabs
- When consuming a recipe which has a "Produces product" set and when the product's "Default stock entry label" is configured accordingly, the corresponding label will now be printed on that action (only server side label printer WebHooks are supported)
- Fixed that hiding the "Requirements fulfilled" column (table options) on the recipes page didn't work
- Fixed that ingredient costs and calories were wrong when product substitution and unit conversions were involved at the same time

### Meal plan

- Added a new sub feature flag `FEATURE_FLAG_RECIPES_MEALPLAN` (in `config.php`) to only disable the meal plan if not needed (thanks @webysther)
- The `config.php` setting `MEAL_PLAN_FIRST_DAY_OF_WEEK` can now be set to `-1` to dynamically start the meal plan week on _today_
- Fixed that consuming a recipe from the meal plan didn't add its "Produces product"-product to stock (if any)
- Fixed that the "Put missing products on shopping list"-button in the header (to put all missing products on the shopping list for a whole week) was missing under certain circumstances (related to locale week numbers and turn of the year)

### Chores

- Changed the handling of the tracking buttons on the chores overview page
  - The green button now tracks an execution of the corresponding chore on the next scheduled time, rather than for now/today
  - New context-/more menu option "Track chore execution now" to track an execution for now/today (so the same what the green button did before)
- Removed the limitation on the chore tracking page that the tracked time couldn't be in the future
- Fixed that "assidgned to" was not recalculated when undoing chores

### Calendar

- Added a button to jump to today (between the prev/next buttons, top right corner)

### Tasks

- Fixed that hiding the "Category" column (table options) on the tasks page didn't work

### Userfields

- Product group Userfields are now also rendered on the shopping list
- Fixed that when having e.g. a Userfield for the `stock` entity and using the "Never overdue" shortcut checkbox for the due date on purchase, this Userfield would also be set to the corresponding "never overdue date"

### General

- Like already possible for products/chores/batteries, locations, stores, quantity units, product groups and task categories can now be disabled to keep them for existing references without deleting them, but to hide them everywhere for selections and so on (new option "Active")
- Added a new `config.php` setting `ENERGY_UNIT` to customize the label to display energy values (was fixed `kcal` before and defaults to that, so no changed behavior when not configured)
- New logo and "Grocy" is now officially spelled with a capital initial letter (before everything was lowercase)
- Various frontend performance enhancements
- Fixed that users were unable to delete their own API keys (when not having the `All permissions` permission)
- Fixed that button tooltips on some places didn't disappear after clicking the corresponding button
- New translations: (thanks all the translators)
  - Estonian (demo available at <https://et.demo.grocy.info>)
  - Romanian (demo available at <https://ro.demo.grocy.info>)

### API

- ⚠️ **Breaking changes**:
  - The product property `qu_factor_purchase_to_stock` was removed (existing factors were migrated to normal product specific QU conversions, see above)
  - Numbers are now returned as numbers (so technically without quotes around them, were strings for nearly all endpoints before)
- Endpoint `/stock/products/{productId}`:
  - Added a new field/property `qu_conversion_factor_purchase_to_stock` for convenience (contains the conversion factor of the corresponding QU conversion from the product's `qu_id_purchase` to `qu_id_stock`)
  - Added a new field/property `qu_conversion_factor_price_to_stock` for convenience (contains the conversion factor of the corresponding QU conversion from the product's `qu_id_price` to `qu_id_stock`)
  - Added a new field/property `default_quantity_unit_consume` (contains the quantity unit object of the product's "Default quantity unit consume")
- The following entities are now also available via the endpoint `/objects/{entity}` (only listing, no edit)
  - `quantity_unit_conversions_resolved` (returns all final/resolved conversion factors per product and any directly or indirectly related quantity units)
  - `recipes_pos_resolved` (returns stock fulfilment information for all recipe ingredients)
- The endpoint `/batteries` now also returns the corresponding battery object (as field/property `battery`)
- API keys can now have a description (to e.g. track where the corresponding key is used)
